/*
 * Decompiled with CFR 0.152.
 */
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TagCounter {
    private final Map<String, Integer> uniqueMatchCounts = new HashMap<String, Integer>();
    private final Map<String, Integer> totalMatchCounts = new HashMap<String, Integer>();
    private final Map<String, Map<String, Integer>> wordMatchStats = new HashMap<String, Map<String, Integer>>();

    public void processText(String string) {
        try {
            System.setOut(new PrintStream((OutputStream)System.out, true, "UTF-8"));
        }
        catch (Exception exception) {
            System.out.println("ERROR: " + exception.getMessage());
        }
        String[] stringArray = string.split("\\r?\\n");
        Pattern pattern = Pattern.compile("^\\s*([A-Za-z0-9_/]+)\\s*\\[(.+?)\\]\\s*$");
        for (String string2 : stringArray) {
            Matcher matcher = pattern.matcher(string2);
            if (!matcher.find()) continue;
            String string3 = matcher.group(1).trim();
            String string4 = matcher.group(2).trim();
            this.totalMatchCounts.put(string3, this.totalMatchCounts.getOrDefault(string3, 0) + 1);
            this.wordMatchStats.putIfAbsent(string3, new HashMap());
            Map<String, Integer> map = this.wordMatchStats.get(string3);
            map.put(string4, map.getOrDefault(string4, 0) + 1);
            this.uniqueMatchCounts.put(string3, this.wordMatchStats.get(string3).size());
        }
    }

    public String printStats() {
        int n = this.totalMatchCounts.values().stream().mapToInt(Integer::intValue).sum();
        Object object = String.format("%-20s %-15s %-15s %-15s%n", "Tag", "Unique Words", "Total Count", "Percentage");
        System.out.printf("%-20s %-15s %-15s %-10s%n", "Tag", "Unique Words", "Total Count", "Percentage");
        for (String string : this.totalMatchCounts.keySet()) {
            int n2 = this.totalMatchCounts.get(string);
            int n3 = this.uniqueMatchCounts.getOrDefault(string, 0);
            double d = n > 0 ? (double)n2 * 100.0 / (double)n : 0.0;
            System.out.printf("%-25s %-15d %-10d %-10.2f%n", string, n3, n2, d);
            object = (String)object + String.format("%-25s %-15d %-10d %-10.2f%n", string, n3, n2, d);
        }
        object = (String)object + "\n-------------------\n";
        return object;
    }

    public static void main(String[] stringArray) {
        String string = "Noun1 [\u0627\u0644\u0652\u062d\u064e\u0645\u0652\u062f\u064f]\nLafzAlJalal_Noun [\u0644\u0650\u0644\u064e\u0651\u0647\u0650]\nNoun1 [\u0627\u0644\u0652\u063a\u064e\u0646\u0650\u064a\u0650\u0651]\nNoun1 [\u0627\u0644\u0652\u062d\u064e\u0645\u0650\u064a\u062f\u0650]\nNoun1 [\u0627\u0644\u0652\u0645\u064f\u0628\u0652\u062f\u0650\u0626\u0650]\nNoun1 [\u0627\u0644\u0652\u0645\u064f\u0639\u0650\u064a\u062f\u0650]\npunctuation [\u060c]\nNoun1 [\u0627\u0644\u0652\u0641\u064e\u0639\u064e\u0651\u0627\u0644\u0650]\nJarrMjror [\u0644\u0650\u0645\u064e\u0627]\nPresent3 [\u064a\u064f\u0631\u0650\u064a\u0652\u062f\u064f]\npunctuation [\u060c]\nPast10 [\u0643\u064e\u062a\u064e\u0628\u064e]\nNoun1 [\u0627\u0644\u0652\u0639\u0650\u0632\u064e\u0651\u0629\u064e]\nAtef_CONJ [\u0648\u064e]\nNoun1 [\u0627\u0644\u0652\u0643\u064e\u0631\u064e\u0627\u0645\u064e\u0629\u064e]\nAsmaaMusol [\u0644\u0650\u0645\u064e\u0646\u0652]\nPast14 [\u0623\u064e\u0637\u064e\u0627\u0639\u064e\u0647\u064f]\npunctuation [\u060c]\nAtef_CONJ [\u0648\u064e]\nPast10 [\u0642\u064e\u0636\u064e\u0649]\nNoun1 [\u0628\u0650\u0627\u0644\u0630\u0650\u0651\u0644\u064e\u0651\u0629\u0650]\nAtef_CONJ [\u0648\u064e]\nNoun1 [\u0627\u0644\u0652\u0647\u064e\u0648\u064e\u0627\u0646\u0650]\nJarrLetter [\u0639\u064e\u0644\u064e\u0649]\nNoun2 [\u0645\u064e\u0646\u0652]\nPast10 [\u0639\u064e\u0635\u064e\u0627\u0647\u064f]\nAtef_CONJ [\u0648\u064e]\nDameerGhaeb_PRON [\u0647\u064f\u0648\u064e]\nNoun1 [\u0627\u0644\u0652\u0639\u064e\u0632\u0650\u064a\u0632\u064f]\nNoun1 [\u0627\u0644\u0652\u062d\u064e\u0643\u0650\u064a\u0645\u064f]\npunctuation [.]\nAtef_CONJ [\u0648\u064e]\nPresent3 [\u0623\u064e\u0634\u0652\u0647\u064e\u062f\u064f]\nNasbLetters [\u0623\u064e\u0646\u0652]\nNafiOrNahi [\u0644\u064e\u0627]\nLafzAlJalal_Noun [\u0625\u0650\u0644\u064e\u0647\u064e]\nEstithnaa [\u0625\u0650\u0644\u064e\u0651\u0627]\nLafzAlJalal_Noun [\u0627\u0644\u0644\u064e\u0651\u0647\u064f]\npunctuation [\u060c]\nPast5 [\u0623\u064e\u0646\u0652\u0639\u064e\u0645\u064e]\nJarrMjror [\u0639\u064e\u0644\u064e\u064a\u0652\u0646\u064e\u0627]\nNoun1 [\u0628\u0650\u0627\u0644\u0652\u0643\u0650\u062a\u064e\u0627\u0628\u0650]\nNoun1 [\u0627\u0644\u0652\u0645\u064f\u0628\u0650\u064a\u0646\u0650]\nAtef_CONJ [\u0648\u064e]\nNoun1 [\u0627\u0644\u0631\u064e\u0651\u0633\u064f\u0648\u0644\u0650]\nNoun1 [\u0627\u0644\u0635\u064e\u0651\u0627\u062f\u0650\u0642\u0650]\nNoun1 [\u0627\u0644\u0652\u0623\u064e\u0645\u0650\u064a\u0646\u0650]\npunctuation [.]\n";
        TagCounter tagCounter = new TagCounter();
        tagCounter.processText(string);
        tagCounter.printStats();
    }
}

